function test_suite = testExp %#ok<STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
p = polysym.empty;
assertEqual(exp(p),polysym.empty)

function testDefault
% Recall that the default value is 0.
p = polysym; 
assertEqual(exp(p),polysym(1))

function testScalar
polysyms('x')
p = exp(x);
assertEqual(p,polysym('exp(x)'))

function testVector
x = polysym('x',[1 2]);
p = exp(x);
assertEqual(p,polysym({'exp(x1)','exp(x2)'}))
